<?php

namespace App\Http\Controllers;
use App\Season;
use Session;
use Illuminate\Http\Request;

class FakeSeasonViewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $series = Season::where('views', '<=', 0)->get();
        return view('admin.fakeview.season.create',compact('series'));
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request data
        $data = $this->validate($request, [
            'series_id' => 'required', // Ensure the movie ID exists in the database
            'views' => 'required|integer|min:1',      // Ensure views is an integer and at least 1
        ]);
    
        try {
            // Find the movie by its ID
            $series = Season::findOrFail($request->series_id);
    
            // Update the views column (increment by the provided value)
            $series->increment('views', $request->views);
    
            // Flash success message
            return redirect('admin/fakeViews')->with('success', __('Views has been updated'));    
            // Redirect back
            return redirect()->back();
        } catch (\Exception $e) {
            // Handle errors and flash an error message
            Session::flash('error', __('An error occurred: ') . $e->getMessage());
            return redirect()->back();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $season = Season::find($id);
        //echo $season->views;
        return view('admin.fakeview.fakeseasonviewedit', compact('season'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (config('app.demolock') == 1) {
            return back()->with('deleted', __('This action is disabled in the demo !'));
        }
        $season=Season::find($id);
        $season->views=$request->views;
        $season->save();

        return redirect('admin/fakeViews')->with('success', __('Views has been updated'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
{
    // Find the fake season view by its ID
    $fakeSeasonView = Season::findOrFail($id);

    // Empty the 'views' column
    $fakeSeasonView->views = 0;

    // Save the changes
    $fakeSeasonView->save();

    // Return a success message
    return redirect('admin/fakeViews')->with('success', __('Views has been deleted'));
}
}
